<?php

require_once __DIR__ . '/Config.php';
require_once __DIR__ . '/library/parser/bootstrap.php';
require_once __DIR__ . '/library/Model.php';
require_once __DIR__ . '/library/API.php';
require_once __DIR__ . '/library/Parser.php';

error_reporting(E_ALL);
ini_set('log_errors', true);
ini_set('error_log', __DIR__ . '/php_error.log');
ini_set('display_errors', 1);
ini_set('memory_limit', '-1');
ini_set('max_execution_time', 60 * 6);
set_time_limit(60 * 6);

$p = new Parser();
$api = new API();
$m = new Model();

$products = $m->getNotParsedProducts(Config::PARSE_PRODUCTS_THREADS);

$products = $p->getProducts($products);
$downloadImages = [];

foreach ($products as $productKey => $prod) {

    if(!$prod['data']['item']) {
        if(isset($prod['data']['error'])) {
            $m->deleteProduct($prod['id']);
        }
        continue;
    }

    if(!$prod['our_user_id'] && $prod['data']['item']['user']['avatarURL']) {

        $avatarURL = preg_replace('/\?.*$/','',$prod['data']['item']['user']['avatarURL']);
        $url = parse_url($avatarURL);
        $fileName = translit($prod['data']['item']['user']['username']) . '.' . pathinfo($avatarURL, PATHINFO_EXTENSION);

        $downloadImages[] = [
            'hideWatermark' => false,
            'url' => $avatarURL,
            'filename' => $fileName,
            'savePath' => Config::USERS_IMAGES_PATH . '/' . $fileName
        ];

        $prod['data']['item']['user']['avatarFileName'] = $fileName;
        $prod['data']['item']['user']['avatarUrl'] = '/users/' . $fileName;
    }

    foreach ($prod['data']['item']['attachments'] as $fileKey => $file) {

        $url = parse_url($file['url']);
        $fileName = /*create_token(6) . '_' .*/
            $prod['id'] . '_' . $fileKey . '.' . pathinfo($file['url'], PATHINFO_EXTENSION);

        $downloadImages[] = [
            'url' => $file['url'],
            'filename' => $fileName,
            'savePath' => Config::PRODUCT_IMAGES_PATH . '/' . $fileName
        ];

        $prod['data']['item']['attachments'][$fileKey]['newFileName'] = $fileName;
        $prod['data']['item']['attachments'][$fileKey]['url'] = '/products/' . $fileName;
    }
    $products[$productKey] = $prod;
}

$p->downloadImages($downloadImages, true);

$apiResult = $api->importProducts([
    'products' => $products
]);

echo "Count " . count($products);