<?php

require_once __DIR__ . '/Config.php';
require_once __DIR__ . '/library/parser/bootstrap.php';
require_once __DIR__ . '/library/Model.php';
require_once __DIR__ . '/library/API.php';
require_once __DIR__ . '/library/Parser.php';

error_reporting(E_ALL);
ini_set('log_errors', true);
ini_set('error_log', __DIR__ . '/php_error.log');


ini_set('display_errors', 1);
ini_set('memory_limit', '-1');
ini_set('max_execution_time', 60 * 5);
set_time_limit(60 * 5);

const SETTINGS_PATH = __DIR__ . '/UpdateOrCreatePlatformsSettings.json';
$set = [];


//if(file_exists(SETTINGS_PATH))
//    $set = json_decode(file_get_contents(SETTINGS_PATH), 1);
//else
$set['after'] = '';


$p = new Parser();
$api = new API();
$m = new Model();
$result = [];
$result['data']['games']['pageInfo']['hasNextPage'] = true;
$total = 0;

while ($result['data']['games']['pageInfo']['hasNextPage']) {

    $result = $p->getPlatforms(Config::PARSE_PLATFORMS_COUNT, $set['after']);

    // check: удаляем если уже есть
    foreach ($result['data']['games']['edges'] as $edgeKey => $edge) {
        if ($m->getPlatformOurIdByOtherId($edge['node']['id'])) {
            unset($result['data']['games']['edges'][$edgeKey]);
        }
    }
    //

    if (isset($result['data']['games']['pageInfo']['endCursor'])) {
        $set['after'] = $result['data']['games']['pageInfo']['endCursor'];
    } else
        exit("ERROR");

    if (!isset($result['data']))
        return exit('result data error');

    $downloadImages = [];
    foreach ($result['data']['games']['edges'] as $key => $platform) {

        echo "NEW: " . $platform['node']['name'] . PHP_EOL;

/*        $fileName = create_token(6) . '_' . $platform['node']['banner']['filename'];
        $downloadImages[] = [
            'url' => $platform['node']['banner']['url'],
            'filename' => $fileName,
            'savePath' => Config::PLATFORM_IMAGES_PATH . '/' . $fileName
        ];

        $result['data']['games']['edges'][$key]['node']['banner']['filename'] = $fileName;*/
        //

        $url = parse_url($platform['node']['logo']['url']);
        $fileName = create_token(6) . '_' . $platform['node']['logo']['filename'];

        $result['data']['games']['edges'][$key]['node']['logo']['filename'] = $fileName;

        $downloadImages[] = [
            'url' => $url['scheme'] . '://' . $url['host'] . $url['path'],
            'filename' => $fileName,
            'savePath' => Config::PLATFORM_IMAGES_PATH . '/' . $fileName
        ];
    }

    $apiResult = '[НечегоНеИмпортировали]';
    if (count($result['data']['games']['edges'])) {
        //Скачиваем изображения и импортируем в базу если они есть
        $p->downloadImages($downloadImages);
        $apiResult = $api->importPlatforms($result);
    }

    $total += Config::PARSE_PLATFORMS_COUNT;
    saveSettins();
    echo "API: " . $apiResult . " - PAGE: $total:" . $result['data']['games']['totalCount'] . '_' . PHP_EOL;
}
saveSettins();
function saveSettins(): int
{
    global $set;
    file_put_contents(SETTINGS_PATH, json_encode($set));
    return 1;
}
