<?php

namespace library;
use Config;
use CURL;

class API
{
    public function makeRequest($method): CURL
    {
        $curl = new CURL(\Config::API_URL . $method, false);
        $curl->set_opt(CURLOPT_HTTPHEADER, [
            'Accept: application/json',
            'Content-Type: application/json'
        ]);
        return $curl;
    }

    public function importPlatforms($data)
    {

        $curl = $this->makeRequest('/dataImport/platforms');

        $data['token'] = Config::API_TOKEN;
        $curl->set_post(json_encode($data));
        $curl->set_opt(CURLOPT_CUSTOMREQUEST, 'PATCH');
        $curl->time_limit(60 * 3);

        $result = $curl->exec(true, $info);
        if ($info['http_code'] != 200) {
            dd([
                'ERROR IMPORT PLATFORMS',
                $info,
                json_decode($result, 1)
            ]);
            return false;
        }
        return $result;
    }

    public function importProducts($data)
    {
        $curl = $this->makeRequest('/dataImport/products');

        $data['token'] = Config::API_TOKEN;
        $curl->set_post(json_encode($data));
        $curl->set_opt(CURLOPT_CUSTOMREQUEST, 'PATCH');
        $curl->time_limit(60 * 3);

        $result = $curl->exec(true, $info);
        if ($info['http_code'] != 200) {
            dd([
                'ERROR IMPORT PLATFORMS',
                $info,
                json_decode($result, 1)
            ]);
            return false;
        }
        return $result;
    }
}