<?php
class Model
{
    public $DB;

    public function __construct()
    {
        $this->DB = new DB(Config::DB_HOST, Config::DB_NAME, Config::DB_USER, Config::DB_PASS, $debug = true);
    }

    public function getUserIdByOtherId(string $otherId)
    {
        return $this->DB->column("SELECT id FROM users WHERE other_id = :id LIMIT 1",[
            'id' => $otherId
        ]);
    }

    public function insertShortProducts(array $items)
    {
        $query = "INSERT INTO products(name, price, priorityPosition, status, description, slug, other_id, category_id, platform_id) VALUES ";
        $params = [];
        $total = 0;
        $nodes = array_column($items, 'node');

        $exists =
            $this->DB->row("SELECT other_id FROM products WHERE other_id IN ('" . implode("','", array_column($nodes, 'id')) . "')");
        $exists = array_column($exists, 'other_id');

        foreach ($nodes as $itemKey => $item) {

            if (!(array_search($item['id'], $exists) === false)) {
                echo "EXISTS[$item[slug]]: $item[name]" . PHP_EOL;
                continue;
            }

            $query .= ($total ? ',' : '') . "(:{$itemKey}_name, :{$itemKey}_price, :{$itemKey}_priorityPosition, :{$itemKey}_status, :{$itemKey}_description, :{$itemKey}_slug, :{$itemKey}_other_id, :{$itemKey}_category_id, :{$itemKey}_platform_id)" . PHP_EOL;
            $params[$itemKey . '_name'] = 'pending';//$item['name'];
            $params[$itemKey . '_price'] = $item['price'];
            $params[$itemKey . '_priorityPosition'] = $item['priorityPosition'];
            $params[$itemKey . '_status'] = $item['status'];
            $params[$itemKey . '_description'] = 'pending';
            $params[$itemKey . '_slug'] = $item['slug'];
            $params[$itemKey . '_other_id'] = $item['id'];
            $params[$itemKey . '_category_id'] = NULL;
            $params[$itemKey . '_platform_id'] = NULL;
            $total++;
        }

        if ($total) {
            try {
                $this->DB->query($query, $params);
            } catch (\Exception $e) {
                echo PHP_EOL . PHP_EOL . PHP_EOL . PHP_EOL . PHP_EOL;
                echo $query . PHP_EOL . PHP_EOL . PHP_EOL;
                echo json_encode($e) . PHP_EOL . PHP_EOL . PHP_EOL;
                echo json_encode($params) . PHP_EOL . PHP_EOL . PHP_EOL;

                exit;
            }
        }else {
            echo "Нечего нету, продолжаем" . PHP_EOL;
        }
    }

    public function getNotParsedProducts($count = 50): false|array
    {
        return $this->DB->row("SELECT id,slug,other_id FROM products WHERE category_id IS NULL ORDER BY RAND() LIMIT $count");
    }

    public function getPlatformOurIdByOtherId($other_id)
    {
        return $this->DB->column("SELECT id FROM platforms WHERE other_id = :id LIMIT 1",[
            'id' => $other_id
        ]);
    }

    public function deleteProduct($id)
    {
        $this->DB->query("DELETE FROM products WHERE id = :id LIMIT 1",compact('id'));
        return true;
    }

    public function getOnlyRussianOptionValues()
    {
        return $this->DB->row("SELECT * FROM product_options WHERE value REGEXP '[а-яА-Я]';");
    }

    public function testSpeed()
    {
        $row = $this->DB->row("select `id`, `name`, `slug`, `price`, `user_id` from `products` where `platform_id` = 1 and `category_id` is not null and `price` >= 13800 and `price` <= 40000 and `products`.`deleted_at` is null order by `id` desc");
        return $row;
    }
}
